<?php

namespace Mtc\ContentManager\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\ContentManager\Models\Menu;

class MenuFactory extends Factory
{
    protected $model = Menu::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'title' => $this->faker->name,
            'description' => $this->faker->paragraph,
            'first_child_element_id' => random_int(0, 1) ? random_int(0, 50) : null,
            'data' => [],
            'is_enabled' => random_int(0, 1),
        ];
    }
}
