<?php

namespace Mtc\ContentManager\Fields;

use Mtc\ContentManager\Contracts\ContentElementField;
use Mtc\ContentManager\Contracts\FormField;

class Toggle extends FormField
{
    /**
     * Name of the field
     *
     * @return string
     */
    public function name(): string
    {
        return __('content::fields.names.toggle');
    }

    public function hasOptions(): bool
    {
        return true;
    }

    /**
     * List of the configuration fields for this input field
     *
     * @return array
     */
    public function fields(): array
    {
        return [
            'instructions' => [
                'type' => 'textarea',
                'name' => __('content::fields.instructions'),
                'instructions' => __('content::fields.instruction_text.instructions'),
            ],
            'required' => [
                'type' => 'checkbox',
                'name' => __('content::fields.required'),
            ],
            'message' => [
                'type' => 'text',
                'name' => 'Message',
                'instructions' => 'Displays text alongside the checkbox',
            ],
            'default_value' => [
                'type' => 'checkbox',
                'name' => __('content::fields.default_value'),
            ],
        ];
    }

    /**
     * Validation rules set on field
     *
     * @param ContentElementField $field
     * @param bool $is_filled
     * @return array
     */
    public function validationRules(ContentElementField $field, bool $is_filled = true): array
    {
        return [
            !empty($field->data['required']) ? 'required' : '',
        ];
    }
}
