<?php

namespace Mtc\ContentManager\Traits;

use Mtc\ContentManager\Contracts\MediaUse;
use Mtc\ContentManager\Http\Resources\MediaEntryResource;

trait MapContentTrait
{
    public function mapContent($pageContent)
    {
        $content = array_merge([
            'id' => $pageContent->id,
            'name' => $pageContent->name,
            'order' => $pageContent->order,
            'slug' => $pageContent->slug,
            'template_element_id' => $pageContent->template_element_id,
            'element_id' => $pageContent->element_id,
            'global_content_id' => $pageContent->global_content_id,
            'content' => $this->getContentValue($pageContent),
            'fieldId' => 'group',
            'icon' => $this->elementIcon($pageContent),
            'nestable' => true,
            'componentName' => false,
            'component' => !empty($pageContent->data['componentName'])
                ? 'EditableContent' . $pageContent->data['componentName']
                : false ,
            'nestedLimit' => 4,
            'editable' => empty($pageContent->global_content_id),
            'globalContent' => !empty($pageContent->global_content_id),
            'repeatable' => true,
            'optionsMenuVisible' => false,
            'type' => $pageContent->data['fieldId'] ?? null,
            'isGroup' => ($pageContent->data['fieldId'] ?? 'group') === 'group',
            'error' => null,
            'children' => $pageContent->subContent
                ? $pageContent->subContent->map(fn ($subContent) => $this->mapContent($subContent))
                : [],

        ], $this->getAdditionalDataValues($pageContent->data));

        $content['meta'] = $this->getMeta($pageContent, $content['meta'] ?? []);
        return $content;
    }

    private function getContentValue($pageContent)
    {
        if (($pageContent->data['fieldId'] ?? '') === 'image') {
            return $pageContent->mediaUses?->pluck('media_id') ?? [];
        }
        return $pageContent->content;
    }

    private function getMeta($pageContent, array $data)
    {
        if (($pageContent->data['fieldId'] ?? '') === 'image') {
            $data['selected'] = $pageContent->mediaUses
                ->map(fn(MediaUse $mediaUse) => new MediaEntryResource($mediaUse));
        }
        if (!empty($pageContent->data['options'])) {
            $data['options'] = $pageContent->data['options'];
        }
        return $data;
    }

    private function elementIcon($pageContent): string
    {
        if ($pageContent->element_id) {
            return $pageContent->element->icon ?? 'layer-group';
        }

        if ($pageContent->global_content_id) {
            return $pageContent->globalContent->contentElement->icon ?? 'layer-group';
        }

        return 'layer-group';
    }

    private function getAdditionalDataValues(?array $data): array
    {
        if ($data === null) {
            return [];
        }

        return collect($data)
            ->except([
                'id',
                'name',
                'slug',
                'order',
                'template_element_id',
                'element_id',
                'global_content_id',
            ])
            ->toArray();
    }
}
