<?php

namespace Mtc\ContentManager\Observers;

use Illuminate\Support\Facades\Auth;
use Mtc\ContentManager\Contracts\PageModel;

class PageObserver
{
    /**
     * Things to do when Page was created
     *
     * @param PageModel $page
     */
    public function saved(PageModel $page)
    {
        $this->attachUser($page, Auth::id());
    }

    /**
     * Attach user to page
     *
     * @param PageModel $page
     * @param $user_id
     */
    protected function attachUser(PageModel $page, $user_id)
    {
        if ($user_id && $page->users()->where('user_id', $user_id)->exists() === false) {
            $page->users()->attach($user_id);
        }
    }
}
