<?php

namespace Mtc\ContentManager\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Mtc\ContentManager\Contracts\MediaUse;
use Mtc\ContentManager\Facades\Media;
use Mtc\ContentManager\Contracts\Media as MediaModel;
use Mtc\ContentManager\ImageSize;

class RegenerateSizesForMediaFileJob implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    public function __construct(protected MediaModel $media)
    {
        //
    }

    public function handle()
    {
        $this->media->uses()
            ->get()
            ->map(fn(MediaUse $mediaUse) => $mediaUse->allowed_sizes)
            ->filter()
            ->flatten()
            ->each(fn($dimensions) => Media::createSize(
                $this->media,
                ImageSize::fromArray(Media::pathStringToArray($dimensions)),
                true
            ));
    }
}
