<?php

namespace Mtc\ContentManager\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\App;
use Mtc\ContentManager\Contracts\GlobalContent;

class TemplateViewResource extends JsonResource
{
    public static $wrap = '';
    /**
     * @var LengthAwarePaginator
     */
    public $resource;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $blockResource = config('pages.content_element_block_resource');
        return [
            'template' => $this->resource,
            'global_content' => new $blockResource(App::make(GlobalContent::class)->newQuery()->paginate(10)),
        ];
    }
}
