<?php

return [
    'auto_load_migrations' => true,
    'load_routes' => true,
    'schedule_tasks' => true,
    'use_transactions' => true,

    /*
    |--------------------------------------------------------------------------
    |  Model Bindings
    |--------------------------------------------------------------------------
    |
    | Bindings for data models
    |
    */
    'page_model' => \Mtc\ContentManager\Models\Page::class,
    'version_model' => \Mtc\ContentManager\Models\Version::class,
    'version_content_model' => \Mtc\ContentManager\Models\VersionContent::class,
    'template_model' => \Mtc\ContentManager\Models\Template::class,
    'content_model' => \Mtc\ContentManager\Models\Content::class,
    'comment_model' => \Mtc\ContentManager\Models\Comment::class,
    'global_content_model' => \Mtc\ContentManager\Models\GlobalContent::class,
    'element_model' => \Mtc\ContentManager\Models\ContentElement::class,
    'element_field_model' => \Mtc\ContentManager\Models\ContentElementField::class,
    'template_element_model' => \Mtc\ContentManager\Models\TemplateElement::class,
    'menu_model' => \Mtc\ContentManager\Models\Menu::class,
    'menu_entry_model' => \Mtc\ContentManager\Models\MenuEntry::class,

    /*
    |--------------------------------------------------------------------------
    | Repository Bindings
    |--------------------------------------------------------------------------
    |
    | Bindings for repository classes that perform actions on data objects
    |
    */
    'page_repository' => \Mtc\ContentManager\PageRepository::class,
    'comment_repository' => \Mtc\ContentManager\CommentRepository::class,
    'element_repository' => \Mtc\ContentManager\ElementRepository::class,
    'field_repository' => \Mtc\ContentManager\FieldRepository::class,
    'menu_repository' => \Mtc\ContentManager\MenuRepository::class,
    'template_repository' => \Mtc\ContentManager\TemplateRepository::class,


    /*
    |--------------------------------------------------------------------------
    | Observer Bindings
    |--------------------------------------------------------------------------
    |
    | Bindings for observer classes used to add-on functionality on model changes
    |
    */
    'page_observer' => \Mtc\ContentManager\Observers\PageObserver::class,
    'global_content_observer' => \Mtc\ContentManager\Observers\GlobalContentObserver::class,
    'template_observer' => \Mtc\ContentManager\Observers\TemplateObserver::class,
    'menu_entry_observer' => \Mtc\ContentManager\Observers\MenuEntryObserver::class,

    /*
    |--------------------------------------------------------------------------
    | Resource Bindings
    |--------------------------------------------------------------------------
    |
    | Bindings for resource objects
    |
    */
    'template_list_resource' => \Mtc\ContentManager\Http\Resources\TemplateListResource::class,
    'template_view_resource' => \Mtc\ContentManager\Http\Resources\TemplateViewResource::class,
    'page_list_resource' => \Mtc\ContentManager\Http\Resources\PageListResource::class,
    'page_view_resource' => \Mtc\ContentManager\Http\Resources\PageViewResource::class,
    'version_list_resource' => \Mtc\ContentManager\Http\Resources\VersionListResource::class,
    'version_view_resource' => \Mtc\ContentManager\Http\Resources\VersionViewResource::class,
    'comment_list_resource' => \Mtc\ContentManager\Http\Resources\CommentListResource::class,
    'menu_list_resource' => \Mtc\ContentManager\Http\Resources\MenuList::class,
    'menu_view_resource' => \Mtc\ContentManager\Http\Resources\MenuView::class,
    'media_list_resource' => \Mtc\ContentManager\Http\Resources\MediaListResource::class,
    'media_file_resource' => \Mtc\ContentManager\Http\Resources\MediaFileResource::class,
    'global_content_list_resource' => \Mtc\ContentManager\Http\Resources\GlobalContentElementList::class,
    'global_content_view_resource' => \Mtc\ContentManager\Http\Resources\GlobalContentElementView::class,
    'element_list_resource' => \Mtc\ContentManager\Http\Resources\ContentElementList::class,
    'element_view_resource' => \Mtc\ContentManager\Http\Resources\ContentElementView::class,
    'content_element_block_resource' => \Mtc\ContentManager\Http\Resources\ContentElementBlockResource::class,

    'page_versions_deleted_after_days' => 90,
    'trashed_pages_deleted_after_days' => 180,

    'thumbnail_sizes' => [
        '64x64',
    ],

    'block_categories' => [
        [
            'id' => 'content',
            'name' => 'Content Elements',
            'order' => 1,
        ],
        [
            'id' => 'supporting',
            'name' => 'Supporting Elements',
            'order' => 2,
        ],
        [
            'id' => 'global',
            'name' => 'Global Elements',
            'order' => 3,
        ],
        [
            'id' => 'navigation',
            'name' => 'Navigation Elements',
            'order' => 4,
        ],
        [
            'id' => 'custom',
            'name' => 'Custom Elements',
            'order' => 999,
        ],
    ],

    'field_types' => [
        'group' => \Mtc\ContentManager\Fields\Group::class,
        'text' => \Mtc\ContentManager\Fields\Text::class,
        'boolean' => \Mtc\ContentManager\Fields\Boolean::class,
        'datetime' => \Mtc\ContentManager\Fields\DateTime::class,
        'number' => \Mtc\ContentManager\Fields\Number::class,
        'image' => \Mtc\ContentManager\Fields\Image::class,
        'location' => \Mtc\ContentManager\Fields\Location::class,
        'select' => \Mtc\ContentManager\Fields\Select::class,
        'checkbox-list' => \Mtc\ContentManager\Fields\Checkbox::class,
        'editor' => \Mtc\ContentManager\Fields\TextArea::class,
    ],

    'route_middleware' => [
        'pages' => [],
        'comments' => [],
        'menus' => [],
        'elements' => [],
        'global-elements' => [],
        'templates' => [],
        'media' => [],
    ]
];
