<?php

namespace Mtc\ContentManager\Fields;

use Mtc\ContentManager\Contracts\ContentElementField;
use Mtc\ContentManager\Contracts\FormField;

class Number extends FormField
{
    /**
     * Name of the field
     *
     * @return string
     */
    public function name(): string
    {
        return __('content::fields.names.number');
    }

    /**
     * List of the configuration fields for this input field
     *
     * @return array
     */
    public function fields(): array
    {
        return [
            'instructions' => [
                'type' => 'textarea',
                'name' => __('content::fields.instructions'),
                'instructions' => __('content::fields.instruction_text.instructions'),
            ],
            'required' => [
                'type' => 'checkbox',
                'name' => __('content::fields.required'),
            ],
            'default_value' => [
                'type' => 'text',
                'value' => 0,
                'name' => __('content::fields.default_value'),
                'instructions' => 'Appears when creating a new record',
            ],
            'placeholder' => [
                'type' => 'text',
                'name' => __('content::fields.placeholder'),
                'instructions' => 'Appears within the input',
            ],
            'prepend' => [
                'type' => 'text',
                'name' => __('content::fields.prepend'),
                'instructions' => 'Appears before the input',
            ],
            'append' => [
                'type' => 'text',
                'name' => __('content::fields.append'),
                'instructions' => 'Appears after the input',
            ],
            'min_value' => [
                'type' => 'text',
                'value' => 0,
                'name' => 'Minimum Value',
            ],
            'max_value' => [
                'type' => 'text',
                'value' => 100,
                'name' => 'Maximum Value',
            ],
            'step_size' => [
                'type' => 'text',
                'value' => 1,
                'name' => 'Step Size',
            ],
        ];
    }

    /**
     * Validation rules set on field
     *
     * @param ContentElementField $field
     * @param bool $is_filled
     * @return array
     */
    public function validationRules(ContentElementField $field, bool $is_filled = true): array
    {
        return [
            !empty($field->data['required']) ? 'required' : '',
            'numeric'
        ];
    }
}
