<?php

namespace Mtc\ContentManager\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\ContentManager\Models\ContentElementField;

class ContentElementFieldFactory extends Factory
{
    protected $model = ContentElementField::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        $simple_element = random_int(0, 5);
        return [
            'element_id' => random_int(0, 50),
            'child_element_id' => $simple_element > 0 ? null : random_int(0, 50),
            'field_type' => $simple_element > 0 ? array_rand(array_keys(config('pages.field_types', []))) : 'element',
            'name' => $this->faker->title,
            'data' => [],
            'choices' => [],
        ];
    }
}
