<?php

namespace Mtc\ContentManager\Contracts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Config;
use Mtc\ContentManager\Factories\ContentElementFieldFactory;

abstract class ContentElementField extends Model
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'content_element_fields';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'element_id',
        'child_element_id',
        'field_type',
        'name',
        'data',
        'choices',
        'order',
    ];

    /**
     * Hidden attributes on json
     *
     * @var string[]
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'data' => 'array',
        'choices' => 'array',
    ];

    /**
     * @return ContentElementFieldFactory
     */
    protected static function newFactory()
    {
        return ContentElementFieldFactory::new();
    }

    /**
     * Relationship with element this field is attached to
     *
     * @return BelongsTo
     */
    public function element(): BelongsTo
    {
        return $this->belongsTo(Config::get('pages.element_model'), 'element_id');
    }

    /**
     * Relationship with element this field is attached to
     *
     * @return BelongsTo
     */
    public function childElement(): BelongsTo
    {
        return $this->belongsTo(Config::get('pages.element_model'), 'child_element_id');
    }
}
