<?php

namespace Mtc\ContentManager\Tests\Unit;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\Validator;
use Mtc\ContentManager\Rules\IsSlugRule;
use Mtc\ContentManager\Tests\TestCase;

class IsSlugRuleTest extends TestCase
{
    public function testImplementsRule(): void
    {
        /** @var IsSlugRule $model */
        $rule = app(IsSlugRule::class);

        $this->assertInstanceOf(Rule::class, $rule);
    }

    public function testRulePasses(): void
    {
        /** @var IsSlugRule $model */
        $rule = app(IsSlugRule::class);

        $tests = [
            'foo' => true,
            'baz-bar' => true,
            'FooBazBar' => false,
            'baz-bar-98' => true,
            'foo baz' => false,
            '*_111' => false,
            '11-tales' => true,
            '11_tales' => false,
            '11Tales' => false,
            '11 tales of Cinderella' => false,
        ];

        foreach  ($tests as $test => $outcome) {
            $this->assertEquals($outcome, $rule->passes('', $test));
        }
    }

    public function testNullValuePasses(): void
    {
        /** @var IsSlugRule $model */
        $rule = app(IsSlugRule::class);

        $this->assertTrue($rule->passes('', null));
    }

    public function testValidationMessage()
    {
        $input = [
            'slug' => 'Foo Baz bar',
        ];
        $rules = [
            'slug' => new IsSlugRule(),
        ];
        $validator = Validator::make($input, $rules);

        $this->assertTrue($validator->fails());
        $errors = $validator->errors()->get('slug');
        $this->assertEquals("Only lowercase letters, numbers and dashes are allowed.", $errors[0]);
    }
}
