<?php

namespace Mtc\ContentManager\Http\Controllers;

use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Config;
use Mtc\ContentManager\CommentRepository;
use Mtc\ContentManager\Contracts\Comment;
use Mtc\ContentManager\Http\Requests\StoreCommentRequest;

class CommentController
{
    use ValidatesRequests;

    /**
     * Store a comment
     *
     * @param StoreCommentRequest $request
     * @param CommentRepository $repository
     * @return array
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(StoreCommentRequest $request, CommentRepository $repository)
    {
        $model = $this->findLinkedModelInstance($request);
        $repository->add($request->input('text'), Auth::id(), $model, $request->input('parent_id'));

        return [
            'success' => true,
            'comments' => $repository->getForModel($model),
        ];
    }

    /**
     * Mark comments as resolved
     *
     * @param Comment $comment
     * @param CommentRepository $repository
     * @return array
     */
    public function markResolved(Comment $comment, CommentRepository $repository)
    {
        return [
            'success' => $repository->markResolved($comment->id),
        ];
    }

    /**
     * Fin the object that is commented
     *
     * @param Request $request
     * @return null
     */
    protected function findLinkedModelInstance(Request $request)
    {
        return match ($request->input('commentable_type')) {
            'page' => App::make(Config::get('pages.page_model'))
                ->newQuery()
                ->findOrFail($request->input('commentable_id')),
            'template' => App::make(Config::get('pages.template_model'))
                ->newQuery()
                ->findOrFail($request->input('commentable_id')),
            default => null,
        };
    }
}
