<?php

namespace Mtc\ContentManager\Facades;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Facade;
use Mtc\ContentManager\Contracts\Media as MediaModel;
use Mtc\ContentManager\Contracts\MediaUse;
use Mtc\ContentManager\MediaRepository;

/**
 * Class Media
 *
 * Media class Facade
 *
 * @method static LengthAwarePaginator getList(Request $request)
 * @method static void addFolders($type, $image_folders)
 * @method static void addPath($path)
 * @method static array getFolders()
 * @method static MediaModel upload(Request $request, MediaModel $mediaToUpdate = null)
 * @method static MediaModel importImageFromUrl(string $url)
 * @method static MediaModel find(int $mediaId)
 * @method static void optimize($media_file_path, bool $lossy = false)
 * @method static mixed resize($media_file_path, $dimensions)
 * @method static array getFiles(Request $request)
 * @method static array getTypes()
 * @method static array getUploadDates()
 * @method static array getTags()
 * @method static array pathStringToArray(string $dimensions)
 * @method static void syncDirectories(string $parent = null)
 * @method static void removeMediaUseSize(MediaUse $mediaUse, int $width, int $height)
 * @method static void destroyMedia(int|array $mediaId)
 * @method static bool pathIsWidthAndHeight(string $path)
 * @method static bool setUsesForModel(array $media, Model $model, array $meta = [])
 * @method static bool setUseOrdering(array $media, Model $model)
 * @see MediaRepository
 */
class Media extends Facade
{
    /**
     * Define the facade accessor
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return 'media_repository';
    }
}
