<?php

namespace Mtc\ContentManager\Providers;

use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;
use Mtc\CustomFields\Events\CustomFieldSaved;
use Mtc\ContentManager\Console\Commands\SyncMediaDirectoryStructureCommand;
use Mtc\ContentManager\Contracts\Media;
use Mtc\ContentManager\Contracts\MediaUse;
use Mtc\ContentManager\Contracts\MediaTag;
use Mtc\ContentManager\Listeners\CustomFieldImageDimensionsChangeListener;
use Mtc\ContentManager\Seeds\DefaultMediaSizeSeeder;
use Mtc\ContentManager\Seeds\MediaMenuSeeder;

class MediaProvider extends ServiceProvider
{
    /**
     * Register service
     *
     * @return void
     */
    public function register(): void
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/media.php', 'media');
        parent::register();

        $this->app->bind(Media::class, Config::get('media.media_model'));
        $this->app->bind(MediaTag::class, Config::get('media.tag_model'));
        $this->app->bind(MediaUse::class, Config::get('media.media_use_model'));
        $this->app->bind('media_repository', Config::get('media.repository_class'));
    }

    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot(): void
    {

        Relation::morphMap([
            'media' => Config::get('media.media_model'),
            'media_use' => Config::get('media.media_use_model')
        ]);

        if ($this->app->runningInConsole()) {
            $this->commands([

            ]);
        }
    }
}
