<?php

return [
    'auto_load_migrations' => true,
    'load_routes' => true,
    'schedule_tasks' => true,

    'page_model' => \Mtc\ContentManager\Models\Page::class,
    'version_model' => \Mtc\ContentManager\Models\Version::class,
    'template_model' => \Mtc\ContentManager\Models\Template::class,

    'page_repository' => \Mtc\ContentManager\PageRepository::class,
    'comment_repository' => \Mtc\ContentManager\CommentRepository::class,
    'menu_repository' => \Mtc\ContentManager\MenuRepository::class,

    'content_model' => \Mtc\ContentManager\Models\Content::class,
    'comment_model' => \Mtc\ContentManager\Models\Comment::class,
    'global_content_model' => \Mtc\ContentManager\Models\GlobalContent::class,
    'element_model' => \Mtc\ContentManager\Models\ContentElement::class,
    'element_field_model' => \Mtc\ContentManager\Models\ContentElementField::class,
    'template_element_model' => \Mtc\ContentManager\Models\TemplateElement::class,
    'menu_model' => \Mtc\ContentManager\Models\Menu::class,
    'menu_entry_model' => \Mtc\ContentManager\Models\MenuEntry::class,

    'page_observer' => \Mtc\ContentManager\Observers\PageObserver::class,
    'global_content_observer' => \Mtc\ContentManager\Observers\GlobalContentObserver::class,
    'template_observer' => \Mtc\ContentManager\Observers\TemplateObserver::class,
    'menu_entry_observer' => \Mtc\ContentManager\Observers\MenuEntryObserver::class,

    'page_versions_deleted_after_days' => 90,
    'trashed_pages_deleted_after_days' => 180,

    'block_categories' => [
        [
            'id' => 'content',
            'name' => 'Content Elements',
            'order' => 1,
        ],
        [
            'id' => 'supporting',
            'name' => 'Supporting Elements',
            'order' => 2,
        ],
        [
            'id' => 'global',
            'name' => 'Global Elements',
            'order' => 3,
        ],
        [
            'id' => 'custom',
            'name' => 'Custom Elements',
            'order' => 999,
        ],
    ],

    'field_types' => [
        'text' => \Mtc\ContentManager\Fields\Text::class,
        'textarea' => \Mtc\ContentManager\Fields\TextArea::class,
        'number' => \Mtc\ContentManager\Fields\Number::class,
        'email' => \Mtc\ContentManager\Fields\Email::class,
        'date' => \Mtc\ContentManager\Fields\Date::class,
        'toggle' => \Mtc\ContentManager\Fields\Toggle::class,
        'select' => \Mtc\ContentManager\Fields\Select::class,
        'image' => \Mtc\ContentManager\Fields\Image::class,
        'file' => \Mtc\ContentManager\Fields\File::class,
        'checkbox' => \Mtc\ContentManager\Fields\Checkbox::class,
        'radio' => \Mtc\ContentManager\Fields\Radio::class,
        'information' => \Mtc\ContentManager\Fields\Message::class,
        'editor' => \Mtc\ContentManager\Fields\Editor::class,
        'url' => \Mtc\ContentManager\Fields\Url::class,
        'range' => \Mtc\ContentManager\Fields\Range::class,
        'password' => \Mtc\ContentManager\Fields\Password::class,
    ],

];
