<?php

namespace Mtc\ContentManager\Traits;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;

trait EnsuresSlug
{
    private function ensureSlug(string $name, Model $model)
    {
        $slug = Str::slug($name);
        if ($model->newQuery()->where('slug', $slug)->exists() === false) {
            return $slug;
        }

        $i = 2;
        do {
            $newSlug = $slug . '-' . $i++;
        } while ($model->newQuery()->where('slug', $newSlug)->exists() || $i > 500);

        if ($i >= 500) {
            Log::error('Failed to generate slug for model', [
                $name,
                $slug,
                $model->getMorphClass(),
            ]);
        }
        return $newSlug;
    }
}
