<?php

namespace Mtc\ContentManager\Observers;

use Illuminate\Support\Facades\Auth;
use Mtc\ContentManager\Contracts\Template;

class TemplateObserver
{
    public function saving(Template $layout)
    {
        if ($layout->isDirty()) {
            $this->attachUpdatedBy($layout);
        }

        $this->setPublishedState($layout);
    }

    private function attachUpdatedBy(Template $layout)
    {
        $layout->updated_by = Auth::id();
    }

    private function setPublishedState(Template $layout): void
    {
        if ($layout->status === true) {
            $layout->status = 'published';
        }
        if ($layout->status === false) {
            $layout->status = 'draft';
        }
    }
}
