<?php

namespace Mtc\ContentManager\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Log;
use Mtc\ContentManager\Facades\Media;
use Mtc\ContentManager\ImageSize;
use Mtc\ContentManager\Models\MediaSize;
use Mtc\ContentManager\Models\MediaUse;

class HandleMediaSizeDimensions implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    public $timeout = 0;

    public function __construct(
        protected readonly MediaSize $mediaSize,
        protected readonly array $original,
        protected readonly bool $changeSize = false
    ) {
        $this->onQueue('media');
    }

    public function handle()
    {
        MediaUse::query()
            ->with('media')
            ->where('owner_type', $this->mediaSize->model)
            ->chunk(config('media.resize_chunk_size'), function (Collection $chunk) {
                if ($this->changeSize) {
                    dispatch(new ChangeMediaSizeDimensions($chunk, $this->mediaSize, $this->original));
                } else {
                    dispatch(new CreateMediaSizeDimensions($chunk, $this->mediaSize));
                }
            });
    }
}
