<?php

namespace Mtc\ContentManager\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Mtc\ContentManager\Rules\IsSlugRule;

class UpdateMenuRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required',
            'slug' => [
                'present',
                new IsSlugRule(),
                'unique:menus,slug,' . ($this->menu->id ?? 0)
            ],
            'first_child_element_id' => [
                'present',
                'nullable',
                'numeric',
                'exists:content_elements,id'
            ],
            'is_enabled' => [
                'required',
                'boolean',
            ],
            'entries' => 'array',
            'entries.*.is_enabled' => [
                'required',
                'boolean',
            ],
            'entries.*.name' => 'required',
            'entries.*.url' => 'required',
            'entries.*.element_id' => [
                'numeric',
                'exists:content_elements,id'
            ],
            'entries.*.content' => [
                'array',
            ],
            'entries.*.data' => [
                'array',
            ],
            'root_entries' => ['array', function ($attribute, $value, $fail) {
                if (!$this->recursiveNameValidation($value)) {
                    $fail('One or more menu items require a valid name.');
                }
            }],
        ];
    }

    protected function recursiveNameValidation($items): bool
    {
        foreach ($items as $item) {
            if (!empty($item['children'])) {
                if (!$this->recursiveNameValidation($item['children'])) {
                    return false;
                }
            }

            if (empty($item['name'])) {
                return false;
            }
        }

        return true;
    }
}
