<?php

namespace Mtc\ContentManager\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\ContentManager\Models\MediaUse;

class MediaUseFactory extends Factory
{
    protected $model = MediaUse::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'media_id' => random_int(1, 10),
            'owner_type' => $this->faker->word(),
            'owner_id' => random_int(1, 10),
            'alt_text' => implode(' ', $this->faker->words(3)),
            'dimensions' => $this->faker->word(),
            'allowed_sizes' => [
                random_int(10, 1000) . 'x' . random_int(10, 1000),
                random_int(10, 1000) . 'x' . random_int(10, 1000),
                random_int(10, 1000) . 'x' . random_int(10, 1000),
            ],
            'data' => json_encode([]),
            'order' => random_int(1, 10),
            'primary' => random_int(0, 1),
            'secondary' => random_int(0, 1),
            'flags' => [],
        ];
    }
}
