<?php

namespace Mtc\ContentManager\Facades;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Facade;
use Mtc\ContentManager\Contracts\Comment as CommentModel;
use Mtc\ContentManager\PageRepository;

/**
 *
 * @method static CommentModel add(string $text, int $author, Model $model, int $parentId = null, array $tagged = [])
 * @method static Collection getForModel(Model $model)
 * @method static bool markResolved(int $id)
 * @see PageRepository
 *
 */
class Comment extends Facade
{
    /**
     * Define the facade accessor
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return 'comment-repository';
    }
}
