<?php

namespace Mtc\Checkout\Events;

use Illuminate\Http\Request;
use Illuminate\Queue\SerializesModels;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;
use Mtc\Checkout\Contracts\InvoiceRepositoryContract;

/**
 * Class PaidInvoice
 *
 * @package Mtc\Checkout
 */
class PaymentSuccessPage
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * Invoice object
     *
     * @var InvoiceRepositoryContract
     */
    public $invoice;

    /**
     * Request
     *
     * @var Request
     */
    public $request;

    /**
     * Whether this event is fired first time or this is a page reload
     *
     * @var bool
     */
    public $first_time;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public function __construct(Request $request, InvoiceRepositoryContract $invoice)
    {
        $this->request = $request;
        $this->invoice = $invoice;
        $this->first_time = !session()->has('invoice_viewed_' . $invoice->getId());
        session()->put('invoice_viewed_' . $invoice->getId(), true);
    }
}
