<?php

namespace Mtc\Checkout\Factories;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Checkout\Contracts\PayableContract;
use Mtc\Checkout\Contracts\PayableFactoryContract;
use Mtc\Orders\Contracts\OrderFactoryContract;

/**
 * Class PayableFactory
 *
 * Create Payable object from request
 *
 * @package Mtc\Checkout
 */
class PayableFactory implements PayableFactoryContract
{
    /**
     * Create an invoice
     *
     * @return mixed
     * @throws \Exception
     */
    public function create(Request $request): PayableContract
    {
        switch ($request->input('type')) {
            case 'basket':
                return App::make(OrderFactoryContract::class)->create(App::make(BasketRepositoryInterface::class));
                break;
        }
        throw new \Exception("Unsupported Payment Object");
    }
}
