<?php

namespace Mtc\Checkout\Console\Commands;

use Illuminate\Console\Command;
use Mtc\Checkout\Providers\CheckoutServiceProvider;

/**
 * Class InstallCheckout
 *
 * @package Mtc\ShippingManager
 */
class InstallCheckout extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'checkout:install';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Install Checkout assets';

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle()
    {
        $this->info('Installing Checkout');

        $this->callSilent('vendor:publish', [
            '--provider' => CheckoutServiceProvider::class,
            '--tag' => 'assets',
        ]);

        $this->info('Checkout installed successfully.');
    }
}
