<?php

namespace Mtc\BitPay\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;
use Mtc\BitPay\Console\Commands\CreateBitPayConfig;
use Mtc\BitPay\Listeners\AddBitPayExternalScripts;
use Mtc\BitPay\Listeners\AddBitPayPaymentIcon;
use Mtc\Checkout\Events\AddPaymentGatewayScripts;

class BitPayProvider extends ServiceProvider
{
    /**
     * Register the application services.
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/bitpay.php', 'bitpay');
    }

    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'bitpay');
        $this->app['payment']->extend('bitpay', function ($app) {
            return $this->app->make(config('bitpay.payment_gateway_class'));
        });

        if (!$this->app->runningInConsole()) {
            Event::listen(AddPaymentGatewayScripts::class, AddBitPayExternalScripts::class);
        } else {
            // Publishing assets.
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/js' => resource_path('js/vendor'),
            ], 'assets');
            // Publishing assets.
            $this->publishes([
                dirname(__DIR__, 2) . '/config/bitpay.php' => config_path('bitpay.php'),
            ], 'config');

            $this->commands([
                CreateBitPayConfig::class,
            ]);
        }

        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');
        Event::listen('checkout.additional_payment_icons', AddBitPayPaymentIcon::class);

        if ($this->app->runningUnitTests() === false) {
            app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');
        }
    }
}
