<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Enabled state and bindings
    |--------------------------------------------------------------------------
    |
    | Enable/Disable gateway.
    |
    | Specify bindings for payment gateway and appicability check
    |
    */
    'enabled' => env('BITPAY_PAYMENTS_ENABLED', true),

    'payment_gateway_class' => \Mtc\BitPay\BitPay::class,
    'applicable_check_class' => \Mtc\BitPay\BitPayApplicableCheck::class,

    /*
    |--------------------------------------------------------------------------
    | Transaction restrictions
    |--------------------------------------------------------------------------
    |
    | Minimal transaction size restriction.
    | Statuses that are considered successful and will mark transaction as processed
    |
    */
    'minimal_transaction_amount' => 0.01,

    'acceptable_payment_statuses' => [
        'paid',
        'confirmed',
        'complete',
    ],

    /*
    |--------------------------------------------------------------------------
    | Transaction statuses
    |--------------------------------------------------------------------------
    |
    | BitPay transactions need to be confirmed in blockchain which can take up
    | to 1 hour to complete. Due to this order is likely to have two states:
    | - initial received/confirmation state that acknowledges transaction is made and is valid
    | - order has been processed within blockchain and has finished.
    | Initial state is returned when transaction is processed and order later
    | is updated via IPN.
    |
    */
    'transaction_received_order_status' => 9,
    'transaction_finished_order_status' => 0,

    /*
    |--------------------------------------------------------------------------
    | Encryption password
    |--------------------------------------------------------------------------
    |
    | This value is required to set up encryption for payment gateway
    |
    */
    'master_password' => env('BITPAY_ENCRYPTION_MASTER_PASSWORD'),
];