# BitPay Payments

This is a payment gateway implementation for [BitPay](https://bitpay.com/).
BitPay provides ability to pay on orders with cryptocurrencies.

# Installation / Setup

Step 1: Install package
```bash
composer require mtcmedia/bitpay-payments

php artisan install:components
```

Step 2: Set up gateway

You need to add following entry to .env file
```dotenv
BITPAY_ENCRYPTION_MASTER_PASSWORD=
```
Password value will be used to generate key file for payment gateway use.
There is no specification on what it should be, it seems to be used only on key generation.

Once you have set the encryption password, create the key files:
```bash
php artisan bitpay:create-config

# For staging 
bitpay:create-config --test
```

Creating config will output details a pairing key that needs to be added to bitpay account 
to enable api credentials - details on how to do this are listed when creating config.

# Test / production mode

Switching between test and production mode is done by creating the config - once 
config is generated the environment specified in it will be used.

Testing payments on test gateway need to be done using a wallet that has 
cryptocurrency allocated on test network. Guide on how to set this up is [here](https://bitpay.com/docs/testing).
This will require installing a wallet app, setting up a wallet on test network and 
getting funds transferred into your test network wallet.

