<?php

namespace Mtc\Basket\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Mtc\Basket\Contracts\SetAddressRequest;
use Mtc\Foundation\Rules\ValidPostcode;

class SetAddress extends FormRequest implements SetAddressRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'type' => 'required',
            'first_name' => 'required',
            'last_name' => 'required',
            'address1' => 'required',
            'city' => 'required',
            'country' => 'required|exists:countries,code',
            'postcode' => new ValidPostcode($this->request->get('country')),
        ];
    }
}
