# Basket

This package provides (ecommerce) basket functionality to mtc platform.

# Installation

`mtcmedia/basket` is part of `mtcmedia/shop` so installation guide is applicable
only when attempting setup without this package. Outcome of this attempt might be
faulty due to potential dependencies on other shop packages.

Steps to install:

Make sure you are installing this on a project that has `composer.mtcassets.com` added as a resource
```bash
composer require mtcmedia/basket
```
This adds package to vendor.
Next step is to run installation via

```bash
php artisan install:components
```
Installer will set up following steps:
- run migrations from package
- seed base data (e.g. menu entry)
- publish assets (vue components)
- install additional npm dependencies
- compile assets

# Configuration

Basket allows a number of elements to be configured in `config/basket.php` including URL stubs, data models,
sections, validation, vat behaviour and others.

# Usage

Key element this package provides is Basket object structure. Primary use case of this pacakge is in ecommerce shop 
use case, however it can be attempted fot be used for different purposes.
Payment workflow is provided within `mtcmedia/checkout` package.

Basket is a data object that contains following data:

* Key customer details (member id, contact info) - `baskets` table
* Customer addresses (billing/shipping/collection etc.) - `basket_addresses` table
* Items in basket (products to be purchased) - `basket_items` table (with `basket_item_lines` for sub-items)
* Discounts applied to basket - `basket_discounts` table
* Surcharges on basket (e.g. delivery cost) - `basket_surcharges` table

## UI

Basket provides two key UI pages (basket and checkout) as well as mini basket (sidebar popup).
UI is built using Vue.js components that interact with basket_store Vuex module.
Vuex ensures communication and consistency between all data components of the basket/checkout pages.

### Basket page

Basket page is the first landing of the checkout process. It shows full details of products and preliminary costs of the purchase.
At this stage customer can adjust quantities in basket, proceed to modify items in basket and potentially receive some upsells.
This section also offers ability to apply coupon/voucher discounts and start some quick-purchase workflows like Apple/Google Pay. 

### Checkout Page

Checkout page is where customer and purchase details are managed. This is a multi-section form that specifies details of the basket.
Default workflow is as follows:

* Contact details
* Shipping type (delivery/collection) - if not virtual purchase
* Shipping / Collection address - if not virtual purchase
* Shipping Method - if not virtual purchase
* Billing address
* Payment selection

Checkout will hide sections that are not yet ready - e.g. Payment selection section will appear only when all sections are validated.

## Basket Items

Basket has been built to allow a wide variety of data models to be purchased. Previous versions of basket were restricted
to allowing only `\Item` object with ways of hacking in sizes or different data objects via manipulating basket. This version
uses `Mtc\Basket\Contracts\Purchasable` contract to provide any object to be added in basket as long as it implements this contract.

_Purchasable_ contract specifies bare necessities for data model to allow it in basket - name, identifier, pricing, stock/quantity and shipping restrictions etc.
As long as Purchasable is implemented Basket will be able to handle product in basket.

Key actions of the basket are performed by `Mtc\Basket\Repositories\BasketRepository` class.

Basket by default assumes that products are actual items and will require delivery. The delivery conditions on items is determined by two factors:

* `Purchasable::requiresShipping()` method allows specifying that product does not require shipping
* `require_delivery_on_zero_weight_items` basket config value allows specifying whether items with weight of 0 do require delivery (as some sites/clients will not fill this info out for products)

### Adding item to basket

Basket adds items to basket via one of two routes:
`/shop/addtobasket` - legacy approach that receives id of item and size details when they are applicable. This route/controller then translates the added item/size details 
to find whether it is item or size that needs to be added to basket.

`/basket/add-item` - universal approach - expects `node_id` to be passed as identifier of product. Products are expected to implement `Nodeable` which is a workflow
that stores additional details in `nodes` table and therefore has a unique reference point of a data entry.

Both routes/controllers do proceed to using `BasketRepository::addItem()` method for adding product in basket.

### Attributes and data

Basket item data table does hold relatively little information and is not meant to be modified in majority of use cases.
If additional data is required against basket items there are two key fields that can be used for this:

`basket_items.attribute_fields` - attribute field allows setting unique "attribute" values of the product. 
These attributes (size/colour/design/scent) will be displayed automatically on basket views. 
Attributes are determined from Purchasable getAttributeFields() method. e.g. Item model will not have any whilst Size will have size/colour. 

`basket_items.data` - data fields are for "hidden" information of the product. This information is not displayed in UI
but is carried throughout basket item to order item and allows storing information like weight/dimensions or other elements
that could be essential for further processing. Data field is not populated from product and therefore must be assigned manually.
For reference how this is done please examine `Mtc\Basket\Listeners\AddWeightToBasketItem` class. Note that the addition is done
by listening to `Mtc\Basket\Events\BasketItemCreating` class. It also performs data setting via assigning temporary variable.
This is required as data is a cast array on Basket\Item object and the array itself is immutable, it can only be replaced with a new array.

### Basket Item Lines

Basket item lines is a future-proof workflow that is not used by default in system. This workflow allows adding sub-items or lines against basket items to provide 
a more detailed breakdown or additional info. A great example use case for this would be Bundle products where bundle has a main price and then proceeds to have details of bundle items. 

## Basket validation

Basket is validated at two stages of the process - basket page and checkout page.

Basket page performs a more generic check to identify whether user can proceed to checkout.
This usually entails checking whether all items are in stock/available. 
This is essential as basket page itself provides quick-purchase options (Apple/Google Pay) so it is essential to make sure purchase can be made for these basket items.
Basket validation is defined by the basket config:

```php
    'basket_validation' => [
        'items' => \Mtc\Basket\Validators\BasketItemValidator::class,
    ],

```

Checkout validation is used to determine if **all** details of the basket are filled out correctly and user can proceed to pay/finalize their purchase.
This means checking all details of the basket - not only items, but customer details, shipping/billing addresses and delivery method (if required by basket).

```php
    'checkout_validation' => [
        'items' => \Mtc\Basket\Validators\BasketItemValidator::class,
        'details' => \Mtc\Basket\Validators\DetailsValidator::class,
        'shipping_address' => \Mtc\Basket\Validators\ShippingAddressValidator::class,
        'delivery_method' => \Mtc\Basket\Validators\ShippingValidator::class,
        'billing_address' => \Mtc\Basket\Validators\BillingAddressValidator::class,
    ],
```

## Discounts 

Discounts are cost reductions on basket. There are two primary means of applying discounts:

* [coupons](https://bitbucket.org/mtcmedia/packages-coupons/)
* [multi-buy-discounts](https://bitbucket.org/mtcmedia/packages-multi-buy-discounts/)

Discount calculations are mostly determined by the discount implementation.
Discounts can be removable by customer (coupons) or non-removable (multi-buy promotions).

`BasketRepository` class offers key methods for manipulating discounts: `addDiscount()`, `hasDiscount()`, `removeDiscount()`

## Surcharges

Surcharges allow adding additional costs on basket that are not products. Primary use of this is
adding [shipping costs](https://bitbucket.org/mtcmedia/packages-shipping-manager/) however other flows like
adding basket-wide gift wrap, insurance on basket and other options are possible.

Surcharges function very similarly to discounts and key difference is that they add basket cost rather than reduce it.

`BasketRepository` class offers key methods for manipulating surcharges: `addSurcharge()`, `hasSurcharge()`, `removeSurcharge()`,
`updateSurchargeByType()`, `getSurchargeIdFromType()`, `removeSurchageByType()`

# Changelog
See [Changelog](CHANGELOG.md)
