<?php

/*
 * You can place your custom package configuration in here.
 */

use Mtc\Checkout\Events\PaymentSuccessPage;
use Mtc\Basket\Events\BasketItemCreating;
use Mtc\Basket\Listeners\AddWeightToBasketItem;
use Mtc\Basket\Listeners\ForgetUsersBasket;

return [
    /*
    |--------------------------------------------------------------------------
    | Route Slugs
    |--------------------------------------------------------------------------
    | These slugs are used to define the url part of the basket route.
    | To ensure routes are easily switchable this slug is used as a config.
    | This way basket name can be updated per necessity
    */

    'basket_route_slug' => 'basket',
    'checkout_route_slug' => 'checkout',

    /*
    |--------------------------------------------------------------------------
    | Quick Buy
    |--------------------------------------------------------------------------
    | When adding to basket through /addtobasket route you can add `quick_buy`
    | attribute to request to trigger automatic redirect to the given route
    */

    'quick_buy_redirect_route' => 'checkout.index',

    /*
    |--------------------------------------------------------------------------
    | Class Bindings
    |--------------------------------------------------------------------------
    | Allow managing classes that are used by the system
    | - model and repository are for managing basket object
    | - response classes are for ajax or html responses from server to browser
    | - product search response is used by checkout order builder product search
    */

    'model' => \Mtc\Basket\Basket::class,
    'basket_loader_class' => \Mtc\Basket\BasketLoaderWithSessionSuperglobalFallback::class,
    'repository_class' => \Mtc\Basket\Repositories\BasketRepository::class,

    'ajax_response_class' => \Mtc\Basket\Http\Resources\BasketAjax::class,
    'checkout_ajax_response_class' => \Mtc\Basket\Http\Resources\CheckoutAjax::class,
    'template_response_class' => \Mtc\Basket\Http\Resources\BasketTemplateResponses::class,
    'product_search_response' => \Mtc\Basket\Http\Resources\ProductSearchResponse::class,

    /*
    |--------------------------------------------------------------------------
    | Event Listeners
    |--------------------------------------------------------------------------
    | Manage events and their listeners here.
    */

    'events' => [
        PaymentSuccessPage::class => [
            ForgetUsersBasket::class
        ],
        BasketItemCreating::class => [
            AddWeightToBasketItem::class,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Request validation setup
    |--------------------------------------------------------------------------
    | Classes that map request validation
    */
    'details_request_validation' => \Mtc\Basket\Http\Requests\BasketDetailsRequest::class,
    'set_address_request' => \Mtc\Basket\Http\Requests\SetAddress::class,

    /*
    |--------------------------------------------------------------------------
    | Workflow Validation setup
    |--------------------------------------------------------------------------
    | Here we define validation conditions for basket and checkout.
    | basket_validation is triggered for basket page and will prevent checkout
    | checkout_validation will trigger on checkout page and can prevent payment
    | Each class performs checks on basket and returns boolean whether section validates
    | All sections must validate to proceed on journey
    */
    'basket_validation' => [
        'items' => \Mtc\Basket\Validators\BasketItemValidator::class,
    ],

    'checkout_validation' => [
        'items' => \Mtc\Basket\Validators\BasketItemValidator::class,
        'details' => \Mtc\Basket\Validators\DetailsValidator::class,
        'shipping_address' => \Mtc\Basket\Validators\ShippingAddressValidator::class,
        'delivery_method' => \Mtc\Basket\Validators\ShippingValidator::class,
        'billing_address' => \Mtc\Basket\Validators\BillingAddressValidator::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Checkout Sections
    |--------------------------------------------------------------------------
    | Define which sections to show on checkout page.
    | Disabling them has not been fully tested so might cause issues
    */
    'allow_checkout_sections' => [
        'shipping_type' => \Mtc\Basket\Validators\AllowShippingTypeSection::class,
        'shipping_types' => \Mtc\Basket\Validators\AllowShippingTypes::class,
        'billing' => \Mtc\Basket\Validators\AllowBillingSection::class,
        'payment' => \Mtc\Basket\Validators\AllowPaymentSection::class,
    ],


    /*
    |--------------------------------------------------------------------------
    | Service Providers
    |--------------------------------------------------------------------------
    | Attach additional service providers for providing routing injection
    */

    'service_providers' => [
        \Mtc\Basket\Providers\BasketRouteServiceProvider::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Stock and adding items in basket
    |--------------------------------------------------------------------------
    | Append setting checks whether adding item adds or sets qty for item in basket
    | Check stock allows checking if item has enough stock during validation
    | Forcing max qty will update stock in basket to max stock of the item
    */

    'append_quantity' => true,
    'max_qty_of_item_in_basket' => 999,
    'force_max_qty_when_adding_item_in_basket' => false,

    /*
    |--------------------------------------------------------------------------
    | Stock and adding items in basket
    |--------------------------------------------------------------------------
    | Backorders allow customers to purchase out of stock items. Not recommended
    | as it can cause calculation discrepancies down the line to invoices/shipments

    */
    'allow_backorders' => false,
    'check_stock_on_items_when_basket_doesnt_check_stock' => false,

    /*
    |--------------------------------------------------------------------------
    | Discounting VAT for basket
    |--------------------------------------------------------------------------
    |
    | Settings to configure VAT for basket
    | Discount vat on basket allows discounting vat from basket items
    | Whereas discount on additions allows removing vat from surcharges / discounts
    | VAT applicable region settings allow setting where VAT does not apply when
    | the full discount values are not true
    | Whether the custom price of basket item is submitted ex.VAT
    */

    'discount_vat_on_basket' => false,
    'discount_vat_on_additions' => false,
    'discount_vat_outside_default_region' => true,
    'vat_does_not_apply_to_channel_islands' => true,
    'vat_applicable_region_conditions' => [
        'code' => 'GB',
    ],
    'custom_price_ex_vat' => false,

    /*
    |--------------------------------------------------------------------------
    | DisplayingVAT for basket
    |--------------------------------------------------------------------------
    |
    | VAT display settings.
    | These do not change vat value, but simply show values with or without
    | VAT on basket / checkout page
    */
    'show_vat_on_basket' => true,
    'subtotal_display_with_vat' => true,
    'discount_display_with_vat' => true,

    /*
    |--------------------------------------------------------------------------
    | Delivery Conditions
    |--------------------------------------------------------------------------
    | Whether 0 weight items require delivery - in case customer doesn't manage weights
    | Preemptive shipping - whether to calculate shipping on basket page before details are set
    |
    */
    'require_delivery_on_zero_weight_items' => true,
    'preemptive_shipping_calculation' => true,
    'preemptive_shipping_address' => [
        'type' => 'shipping',
        'first_name' => '',
        'last_name' => '',
        'country' => 'GB',
    ],

    /*
    |--------------------------------------------------------------------------
    | Basket Layout
    |--------------------------------------------------------------------------
    |
    | Define basket page layout
    |
    */

    'basket_page_structure' => [
        [
            'template' => 'content/partials/discount_bar.twig',
            'data' => [],
        ],
        [
            'template' => 'content/partials/basket_columns.twig',
            'data' => [
                'left' => [
                    [
                        'template' => 'basket/partials/items.twig'
                    ],
                    [
                        'template' => 'basket/partials/multi-buy-discounts.twig'
                    ],
                    [
                        'template' => 'basket/partials/basket-upsells.twig'
                    ]
                ],
                'right' => [
                    [
                        'template' => 'basket/partials/summary.twig'
                    ]
                ],
            ]
        ],
        [
            'template' => 'content/partials/banner.twig',
        ]
    ]
];
