<?php

namespace Mtc\Basket\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Mtc\Basket\Contracts\BasketRepositoryInterface;
use Mtc\Foundation\Country;
use Mtc\Basket\Address;
use Mtc\Foundation\Http\Resources\CountryList;
use Mtc\ShippingManager\Facades\Shipping;

/**
 * Class BasketAjax
 *
 * @package Mtc\Basket\Http\Resources
 */
class BasketTemplateResponses
{
    /**
     * Basket page template
     *
     * @param Request $request
     * @param BasketRepositoryInterface $basket
     * @return string
     */
    public function basket(Request $request, BasketRepositoryInterface $basket)
    {
        $page_meta = App::make('page_meta');
        $page_meta['title'] = 'Basket | ' . config('app.name');
        return template('basket/index.twig', [
            'page_meta' => $page_meta,
        ]);
    }

    /**
     * Checkout page template
     *
     * @param Request $request
     * @param BasketRepositoryInterface $basket
     * @return string
     */
    public function checkout(Request $request, BasketRepositoryInterface $basket)
    {
        $countries = Country::query()
            ->with('states')
            ->where('status', 1)
            ->get();

        $address = Address::$blueprint;
        $address['country'] = config('foundation.primary_country');

        $page_meta = App::make('page_meta');
        $page_meta['title'] = 'Checkout | ' . config('app.name');
        return template('checkout/index.twig', [
            'page_meta' => $page_meta,
            'countries' => new CountryList($countries),
            'shipping_types' => Shipping::enabledTypes(),
            'collect_locations' => Shipping::collectLocations($basket),
            'empty_address' => $address,
        ]);
    }
}
