<?php

namespace Mtc\Basket\Validators;

use Illuminate\Support\Facades\Validator;
use Mtc\Foundation\Rules\ValidPostcode;

/**
 * Class BillingAddressValidator
 *
 * @package Mtc\Basket
 */
class BillingAddressValidator extends BaseBasketValidator
{

    /**
     * Check if there is delivery address error
     *
     * @return bool
     */
    public function handle()
    {
        $address = $this->basket->billingAddress ? $this->basket->billingAddress->toArray() : [];
        $validator = Validator::make($address, [
            'type' => 'required',
            'first_name' => 'required',
            'last_name' => 'required',
            'address1' => 'required',
            'city' => 'required',
            'country' => 'required|exists:countries,code',
            'postcode' => new ValidPostcode($address['country'] ?? ''),
        ]);

        return $validator->passes();
    }
}
