<?php

namespace Mtc\Basket\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider;
use Mtc\Checkout\Events\PaymentSuccessPage;
use Mtc\Orders\Events\OrderPaid;
use Mtc\Basket\Listeners\ForgetUsersBasket;

/**
 * Class BasketRouteServiceProvider
 *
 * @package Mtc\Basket\Providers
 */
class BasketEventServiceProvider extends EventServiceProvider
{
    /**
     * The event handler mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        PaymentSuccessPage::class => [
            ForgetUsersBasket::class
        ]
    ];
}

