<?php

namespace Mtc\Basket;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Surcharge
 *
 * @package Mtc\Basket
 */
class Surcharge extends Model
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'basket_surcharges';

    /**
     * Columns that cannot be mass assigned
     *
     * @var array
     */
    protected $guarded = [
        'id'
    ];

    /**
     * Touch (update) relationship when changes are made
     *
     * @var array
     */
    protected $touches = [
        'basket',
    ];

    /**
     * Hide attributes from ajax response
     *
     * @var array
     */
    protected $hidden = [
        'surcharge_id',
        'surcharge_type',
        'basket_id',
        'created_at',
        'updated_at',
        'surcharge',
    ];

    /**
     * Append attributes to JSON response
     *
     * @var array
     */
    protected $appends = [
        'name',
        'price',
    ];

    /**
     * Relationship with Basket
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function basket()
    {
        return $this->belongsTo(Basket::class);
    }

    /**
     * Relationship with surcharge
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function surcharge()
    {
        return $this->morphTo('surcharge');
    }

    /**
     * Show name attribute from surcharge
     *
     * @return mixed
     */
    public function getNameAttribute()
    {
        return $this->surcharge->getNameAttribute();
    }

    /**
     * Show price attribute surcharge
     *
     * @return mixed
     */
    public function getPriceExVatAttribute()
    {
        return $this->surcharge->getPriceAttribute()->raw(false);
    }

    /**
     * Show price attribute surcharge
     *
     * @return mixed
     */
    public function getPriceAttribute($with_vat = null)
    {
        $with_vat = $with_vat ?? config('basket.subtotal_display_with_vat');
        return $this->surcharge->getPriceAttribute()->raw($with_vat);
    }

    /**
     * Show price attribute surcharge
     *
     * @return mixed
     */
    public function getTaxAttribute()
    {
        return $this->surcharge->getPriceAttribute()->tax();
    }
}
