<?php

namespace Mtc\Basket;

use Illuminate\Http\Request;
use Mtc\Foundation\Manager;

/**
 * Class PurchasableManager
 *
 * @package Mtc\Basket
 */
class PurchasableManager extends Manager
{
    /**
     * Get the list of applicable payment forms for the payment
     *
     * @param Request $request
     * @return array
     */
    public function find(Request $request)
    {
        $this->createMissingDrivers();
        return collect($this->drivers)
            ->map(function ($driver) use ($request) {
                return $driver->searchByTerm($request->input('term', ''))
                    ->take($request->input('limit', 20))
                    ->get();
            });
    }

    /**
     * Define the name of the config driver will use to set the active driver
     *
     * @return string
     */
    public function getDriverConfigName(): string
    {
        return 'basket.purchasable';
    }

    /**
     * Manager Name registered (i.e. facade accessor)
     *
     * @return string
     */
    public function getManagerName(): string
    {
        return 'purchasable';
    }
}
