<?php

namespace Mtc\BasketRecovery\Traits;

use Illuminate\Http\Request;
use Mtc\BasketRecovery\Models\BasketRecoveryEmail;

/**
 * Trait CanRetrieveToken
 *
 * @package Mtc\BasketRecovery\Traits
 */
trait CanRetrieveToken
{

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return bool|\Mtc\BasketRecovery\Models\BasketRecoveryEmail
     */
    protected function getRecoveryEmailFromRequest(Request $request)
    {

        $recovery_email = BasketRecoveryEmail::findByToken($request->get('token', null));

        if (is_null($recovery_email)) {
            return false;
        }

        if (is_null($recovery_email->basket)) {
            return false;
        }

        if (is_null($recovery_email->basketRecovery)) {
            return false;
        }

        return $recovery_email;

    }

}