<?php

namespace Mtc\BasketRecovery\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Mtc\BasketRecovery\Hooks\AdminLayout;
use Mtc\BasketRecovery\Listeners\DestroySentEmailsIfPaid;
use Mtc\BasketRecovery\Listeners\LogOrderPaid;
use Mtc\Orders\Events\OrderPaid;

/**
 * Class EventServiceProvider
 *
 * @package Mtc\BasketRecovery\Providers
 */
class EventServiceProvider extends ServiceProvider
{

    /**
     * List of events and their processors
     * 
     * @var array
     */
    protected $listen = [
        OrderPaid::class => [
            LogOrderPaid::class,
            DestroySentEmailsIfPaid::class
        ]
    ];

    public function boot()
    {
        parent::boot();

        if ($this->app->runningUnitTests()) {
            return;
        }

        \HooksAdapter::add_action('admin_footer', AdminLayout::class . '::adminFooter', 10, 1);

    }

}
