<?php

namespace Mtc\BasketRecovery\Listeners;

use Mtc\BasketRecovery\Models\BasketRecoveryEmail;
use Mtc\Orders\Events\OrderPaid;

/**
 * Class DestroySentEmailsIfPaid
 *
 * @package Mtc\BasketRecovery
 */
class DestroySentEmailsIfPaid
{

    /**
     * @param \Mtc\Orders\Events\OrderPaid $event
     */
    public function handle(OrderPaid $event)
    {
        /** @var \Mtc\Basket\Basket $basket */
        $basket = $event->getOrder()->basket()->first();
        BasketRecoveryEmail::query()->where('basket_id', $basket->id)->delete();
    }
}
