<?php

namespace Mtc\BasketRecovery\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Mtc\BasketRecovery\Traits\CanRetrieveToken;

/**
 * Class ReadBasketController
 *
 * @package Mtc\BasketRecovery\Http\Controllers
 */
class ReadRecoveryEmailController extends Controller
{
    use CanRetrieveToken;

    /**
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function __invoke(Request $request)
    {
        if (!$recovery_email = $this->getRecoveryEmailFromRequest($request)) {
            return $this->showImage();
        }

        $recovery_email->markAsRead();
        return $this->showImage();

    }

    /**
     * @return \Illuminate\Http\Response
     */
    public function showImage()
    {
        return response()->file(dirname(__DIR__, 3) . '/resources/images/blank.gif');
    }

}