<?php

namespace Mtc\BasketRecovery\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Mtc\BasketRecovery\Models\BasketRecovery;

/**
 * Class StoreBasketRecoveryRequest
 *
 * @package Mtc\BasketRecovery\Http\Requests\Admin
 */
class PersistBasketRecoveryRequest extends FormRequest
{

    /**
     * @return array
     */
    public function rules()
    {
        return [
            'subject' => ['required', 'string'],
            'content' => ['required', 'string'],
            'unit' => ['required', 'numeric', 'between:0,121'],
            'measurement' => ['required', Rule::in(BasketRecovery::getAllowedIntervals())]
        ];
    }

    /**
     * @return array
     */
    public function validated()
    {
        return array_merge(parent::validated(), [
            'is_active' => $this->has('is_active'),
            'coupon_data' => $this->areCouponsEnabled() ? $this->get('coupon_data', []) : []
        ]);
    }

    /**
     * @return boolean
     */
    protected function areCouponsEnabled()
    {
        return config('basket_recovery.coupons.enabled', false);
    }

}