<?php

namespace Mtc\BasketRecovery\Http\Controllers\Admin;

use Mtc\Basket\Basket;
use Mtc\Basket\Item;
use Mtc\BasketRecovery\Models\BasketRecovery;
use Mtc\BasketRecovery\Models\BasketRecoveryEmail;

/**
 * Class PreviewBasketRecoveryController
 *
 * @package Mtc\BasketRecovery\Http\Controllers\Admin
 */
class PreviewBasketRecoveryController
{

    /**
     * @param $basket_recovery
     *
     * @return \Illuminate\View\Factory|\Illuminate\View\View
     */
    public function __invoke($basket_recovery_id)
    {
        $basket_recovery = BasketRecovery::query()->findOrFail($basket_recovery_id);
        $token = BasketRecoveryEmail::generateToken();

        return template('BasketRecovery/emails/basket_recovery_email.twig', [
            'basket_recovery' => $basket_recovery,
            'items' => $this->getBasket()->items,
            'coupon' => false,
            'currency' => $this->getBasket()->unpaidOrders()->latest()->first()->currency_code ?? config('currencies.default_currency', ''),
            'basket_recovery_url' => route('basket-recovery.recover', compact('token')),
            'basket_recovery_image' => route('basket-recovery.read', compact('token'))
        ]);

    }

    /**
     * @return \Illuminate\Database\Eloquent\Builder|\Illuminate\Database\Eloquent\Model|object|null
     */
    protected function getBasket()
    {
        /** @var Basket $basket */
        $basket = app(config('basket.model', Basket::class));
        return $basket->newQuery()->whereHas('items')->latest()->first();
    }

}
