<?php

$isS3 = env('FILE_STORAGE_DRIVER', 'local') === 's3';
return [

    /*
    |--------------------------------------------------------------------------
    | Default Filesystem Disk
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default filesystem disk that should be used
    | by the framework. The "local" disk, as well as a variety of cloud
    | based disks are available to your application. Just store away!
    |
    */

    'default' => env('FILESYSTEM_DRIVER', 'local'),
    'default_media' => env('FILESYSTEM_MEDIA_DRIVER', 'public'),

    /*
    |--------------------------------------------------------------------------
    | Filesystem Disks
    |--------------------------------------------------------------------------
    |
    | Here you may configure as many filesystem "disks" as you wish, and you
    | may even configure multiple disks of the same driver. Defaults have
    | been setup for each driver as an example of the required options.
    |
    | Supported Drivers: "local", "ftp", "sftp", "s3"
    |
    */

    'disks' => [

        'local' => [
            'driver' => 'local',
            'root' => storage_path('app'),
        ],

        'public' => [
            'driver' => 'local',
            'root' => storage_path('app/public'),
            'url' => env('APP_URL') . '/storage',
            'visibility' => 'public',
        ],

        's3' => [
            'driver' => 's3',
            'key' => env('AWS_ACCESS_KEY_ID'),
            'secret' => env('AWS_SECRET_ACCESS_KEY'),
            'region' => env('AWS_DEFAULT_REGION'),
            'bucket' => env('AWS_BUCKET'),
            'url' => env('AWS_URL'),
            'endpoint' => env('AWS_ENDPOINT'),
            'use_path_style_endpoint' => env('AWS_USE_PATH_STYLE_ENDPOINT', false),
        ],

        'file-storage' => [
            'driver' => env('FILE_STORAGE_DRIVER', 'local'),
            'key' => env('DO_ACCESS_KEY_ID'),
            'secret' => env('DO_SECRET_ACCESS_KEY'),
            'region' => env('DO_DEFAULT_REGION'),
            'bucket' => env('DO_BUCKET'),
            'url' => $isS3 ? env('DO_URL') : env('APP_URL') . '/storage',
            'endpoint' => env('DO_ENDPOINT'),
            'cdn_endpoint' => env('DO_CDN_ENDPOINT'),
            'use_path_style_endpoint' => env('DO_USE_PATH_STYLE_ENDPOINT', false),
            ($isS3 ? 'folder' : 'root') => ($isS3 ? 'file-storage' : storage_path('app/public')),
        ],


        'media' => [
            'driver' => env('FILE_STORAGE_DRIVER', 'local'),
            'key' => env('DO_ACCESS_KEY_ID'),
            'secret' => env('DO_SECRET_ACCESS_KEY'),
            'region' => env('DO_DEFAULT_REGION'),
            'bucket' => env('DO_BUCKET'),
            'url' => $isS3 ? env('DO_URL') : env('APP_URL') . '/storage/media',
            'endpoint' => env('DO_ENDPOINT'),
            'cdn_endpoint' => env('DO_CDN_ENDPOINT'),
            'use_path_style_endpoint' => env('DO_USE_PATH_STYLE_ENDPOINT', false),
            ($isS3 ? 'folder' : 'root') => ($isS3 ? 'media' : storage_path('app/public/media')),
        ],

        'content-icons' => [
            'driver' => env('FILE_STORAGE_DRIVER', 'local'),
            'key' => env('DO_ACCESS_KEY_ID'),
            'secret' => env('DO_SECRET_ACCESS_KEY'),
            'region' => env('DO_DEFAULT_REGION'),
            'bucket' => env('DO_BUCKET'),
            'url' => $isS3 ? env('DO_URL') : env('APP_URL') . '/storage/icons',
            'endpoint' => env('DO_ENDPOINT'),
            'cdn_endpoint' => env('DO_CDN_ENDPOINT'),
            'use_path_style_endpoint' => env('DO_USE_PATH_STYLE_ENDPOINT', false),
            ($isS3 ? 'folder' : 'root') => ($isS3 ? 'assets' : storage_path('app/public/assets')),
        ],

    ],

    /*
    |--------------------------------------------------------------------------
    | Symbolic Links
    |--------------------------------------------------------------------------
    |
    | Here you may configure the symbolic links that will be created when the
    | `storage:link` Artisan command is executed. The array keys should be
    | the locations of the links and the values should be their targets.
    |
    */

    'links' => [
        public_path('storage') => storage_path('app/public'),
    ],

];
