<?php

namespace App\Metrics;

use Illuminate\Support\Facades\DB;
use Mtc\MercuryDataModels\Enquiry;
use Mtc\MercuryDataModels\Vehicle;
use Spatie\Analytics\Period;

class VehiclesAdded
{
    public function get(Period $period)
    {
        return Vehicle::query()
            ->select(DB::raw('count(*) as count'), DB::raw('DATE(created_at) as date'))
            ->where('created_at', '>=', $period->startDate->format('Y-m-d'))
            ->where('created_at', '<=', $period->endDate->format('Y-m-d 23:59:59'))
            ->groupBy('date')
            ->get()
            ->pluck('count', 'date');
    }
}
