<?php

namespace App\Metrics;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Mtc\MercuryDataModels\Enquiry;
use Mtc\MercuryDataModels\ReportingStat;
use Mtc\MercuryDataModels\Vehicle;
use Spatie\Analytics\Period;

class VehicleCount
{
    public function get(Period $period)
    {
        return ReportingStat::query()
            ->where('key', 'vehicle-count')
            ->select(['value', 'date'])
            ->where('date', '>=', $period->startDate->format('Y-m-d'))
            ->where('date', '<=', $period->endDate->format('Y-m-d'))
            ->get()
            ->keyBy(fn($row) => $row->date->format('Y-m-d'))
            ->map(fn($row) => $row->value);
    }
}
