<?php

namespace App\Http\Requests;

use App\Tier;
use App\TierHelper;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Http\FormRequest;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;

class DerivativeLookupRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return TierHelper::isAllowed(tenant('tier'), Tier::PRO->value);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'make_id' => [
                'required',
                'exists:vehicle_makes,id',
            ],
            'model_id' => [
                'required',
                'exists:vehicle_models,id',
            ],
            'vehicle_id' => [
                'sometimes',
                'numeric',
                'exists:new_cars,id',
            ],
        ];
    }

    public function make(): VehicleMake|Model
    {
        return VehicleMake::query()->findOrFail($this->input('make_id'));
    }

    public function model(): VehicleModel|Model
    {
        return VehicleModel::query()->findOrFail($this->input('model_id'));
    }

    public function vehicleId(): ?int
    {
        return $this->input('vehicle_id');
    }
}
