<?php

namespace Tests;

class TestSettingRepository
{
    private array $loaded_settings = [];
    private array $settings_order = [];

    public function make(array $setting, bool $withValue = false)
    {
        if (($setting['type'] ?? null) == 'image') {
            $this->loaded_settings[$setting['config_key']] = [
                'url' => $setting['value'] ?? '',
                'path' =>  $setting['value'] ?? '',
            ];
        } else {
            $this->loaded_settings[$setting['config_key']] = $setting['value'] ?? null;
        }
        $this->settings_order[$setting['config_key']] = $setting['order'] ?? 99;
    }

    public function exists(string $key): bool
    {
        return isset($this->loaded_settings[$key]);
    }

    public function get(string $key, $default = null)
    {
        return $this->loaded_settings[$key] ?? $default;
    }

    public function update(string $key, $value)
    {
        $this->loaded_settings[$key] = $value;
    }

    /**
     * @param string $key
     * @return void
     */
    public function delete(string $key): void
    {
        unset($this->loaded_settings[$key]);
    }

    public function getOrder(string $key): int
    {
        return $this->settings_order[$key] ?? 99;
    }
}
