<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\Modules\Valuation\Config\AutoTrader;
use App\Modules\Valuation\Config\CapConfig;
use Illuminate\Support\Facades\App;
use Mtc\VehicleLookup\Config\EVAConfig;
use Tests\TenantTestCase;

class ValuationConfigTest extends TenantTestCase
{
    public function testCapConfig()
    {
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'valuation-cap-enabled',
            'value' => true,
            'type' => 'boolean',
        ]);
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'valuation-cap-subscriber_id',
            'value' => 'abc-123',
            'type' => 'string',
        ]);
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'valuation-cap-password',
            'value' => 'foo-baz',
            'type' => 'secret',
        ]);

        /** @var CapConfig $config */
        $config = App::make(CapConfig::class);

        $this->assertTrue($config->enabled());
        $this->assertEquals('abc-123', $config->subscriberId());
        $this->assertEquals('foo-baz', $config->password());
    }

    public function testAutoTraderConfig()
    {
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'valuation-auto-trader-enabled',
            'value' => true,
            'type' => 'boolean',
        ]);
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'auto-trader-advertiser-id',
            'value' => 'abc-123',
            'type' => 'string',
        ]);
        /** @var AutoTrader $config */
        $config = App::make(AutoTrader::class);

        $this->assertTrue($config->enabled());
        $this->assertEquals('abc-123', $config->merchantId());
    }

    public function testEVAConfig()
    {
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'valuation-eva-enabled',
            'value' => true,
            'type' => 'boolean',
        ]);

        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'valuation-eva-client-id',
            'value' => 'foo',
            'type' => 'string',
        ]);

        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'valuation-eva-client-secret',
            'value' => 'bar',
            'type' => 'string',
        ]);

        $config = App::make(EVAConfig::class);
        $headers = $config->tokenAuthHeaders();

        $this->assertTrue($config->enabled());
        $this->assertIsArray($headers);
        $auth_header = reset($headers);
        $this->assertStringContainsString('Basic', $auth_header);
        $this->assertStringContainsString('bar', base64_decode(str_replace('Basic ', '', $auth_header)));
    }
}
