<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use Tests\TenantTestCase;

class RestrictedAccessTest extends TenantTestCase
{
    public function testVehicleAction()
    {
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'site-access-enabled',
            'value' => false,
            'type' => 'boolean',
        ]);

        $response = $this->getJson(route('get-site'));
        $response->assertStatus(200);

        $this->assertArrayHasKey('restricted_access', $response->json());
        $this->assertFalse($response->json('restricted_access'));

        Settings::update('site-access-enabled', true);
        $response = $this->getJson(route('get-site'));
        $this->assertTrue($response->json('restricted_access'));
    }

    public function testCheckAccess()
    {
        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'site-access-password',
            'value' => 'foo-baz-bar',
            'type' => 'secret',
        ]);

        $response = $this
            ->postJson(route('check-site-access'), [
                'password' => 'lorem-ipsum',
            ]);

        $response->assertStatus(403);

        $response = $this
            ->postJson(route('check-site-access'), [
                'password' => 'foo-baz-bar',
            ]);

        $response->assertStatus(200);
    }
}
