<?php

namespace Tests\Tenant;

use App\Modules\Stock\Motordat;
use Illuminate\Support\Facades\App;
use Mtc\ContentManager\Models\Media;
use Tests\TenantTestCase;

class MotordatTest extends TenantTestCase
{
    public function testMotorDatReturnsImageUrl()
    {
        $media = Media::factory()->create(['src' => 'foo.png']);
        /** @var Motordat $service */
        $service = App::make(Motordat::class);

        $url = $service->url($media, 'large');
        $this->assertIsString($url);
        $this->assertStringContainsString('motordat.com', $url);
        $this->assertStringContainsString('foo.png', $url);
        $this->assertStringContainsString('large', $url);
    }

    public function testMotorDatSizeMapping()
    {
        $media = Media::factory()->create(['src' => 'foo.png']);
        /** @var Motordat $service */
        $service = App::make(Motordat::class);

        $url = $service->url($media, 'large');
        $this->assertStringContainsString('large', $url);
        $url = $service->url($media, 'original');
        $this->assertStringContainsString('verylarge', $url);
        $url = $service->url($media, 'custom');
        $this->assertStringContainsString('large', $url);
        $url = $service->url($media, 'smallthumbs');
        $this->assertStringContainsString('smallthumbs', $url);
    }
}
