<?php

namespace Tests\Tenant;

use App\Facades\Settings;
use App\IntegrationRepository;
use Tests\TenantTestCase;

class IntegrationRepositoryTest extends TenantTestCase
{
    public function testEnabledForType()
    {
        $repository = (new IntegrationRepository());

        $enabled = $repository->getEnabledForType('finance');
        $this->assertTrue($enabled->isEmpty());

        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'finance-ivendi-enabled',
            'value' => true,
            'type' => 'boolean',
        ]);

        $enabled = $repository->getEnabledForType('finance');
        $this->assertEquals(1, $enabled->count());

        $this->assertEquals('finance-ivendi-enabled', $enabled->first()['config_key']);
    }

    public function testAllForType()
    {
        $repository = (new IntegrationRepository());

        $repository->getAllForType('finance');
        $enabled = $repository->getAllForType('finance');
        $this->assertEquals(3, $enabled->count());

        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'finance-ivendi-enabled',
            'value' => true,
            'type' => 'boolean',
        ]);

        $enabled = $repository->getAllForType('finance');
        $this->assertEquals(3, $enabled->count());
    }
    public function testNonEmptyValuesForType()
    {
        $repository = (new IntegrationRepository());

        $values = $repository->findNonEmptyValuesForType('finance');
        $this->assertTrue($values->isEmpty());

        Settings::make([
            'tab' => 'foo',
            'section' => 'lorem',
            'group' => 'ipsum',
            'name' => 'dolor',
            'config_key' => 'finance-ivendi-enabled',
            'value' => true,
            'type' => 'boolean',
        ]);

        $values = $repository->findNonEmptyValuesForType('finance');
        $this->assertFalse($values->isEmpty());
        $this->assertTrue($values->has('ivendi'));
    }
}
